 @extends('admin.layouts.app', ['activePage' => 'dashboard', 'titlePage' => __('Dashboard')])

@section('content')
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Update Booking</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item ">Booking</li>
              <li class="breadcrumb-item active">Update</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">

            <div class="col-md-12">
            <!-- general form elements -->
            <div class="card card-primary">
              <div class="card-header">
                <h3 class="card-title">Update Form</h3>
              </div>
              <!-- /.card-header -->
              <!-- form start -->
              <form method="POST" action="{{route('Booking.update',$data->id)}}">
                @csrf
                @method('PUT')
                
                <div class="card-body">
                   <div class="form-group">
                    <label for="currentstatus">Current Place</label>
                    <input type="text" class="form-control"   id="currentstatus" name="currentstatus" placeholder="Enter Current Location of parcel">
                  </div>
                  <div class="form-group">
                    <label for="currentstatus">Details</label>
                    <input type="text" class="form-control"   id="currentstatus" name="remark" placeholder="Enter Any Remark">
                  </div>
                  <div class="form-group">
                    <label for="status">Status</label>
                    <select class="custom-select rounded-0" id="status" name="status"  required>
                    <option value="Shipped">Shipped</option>
                    <option value="Intransit">Intransit</option>
                    <option value="Delivered">Delivered</option>
                  </select>
                  </div>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.2.3/jquery.min.js"></script>
<script type="text/javascript">
$('#status option[value= {{$data->status}} ]').attr("selected","selected");</script>
                </div>
                <!-- /.card-body -->
                <div class="card-footer">
                  <button type="submit" class="btn btn-primary">Submit</button>
                </div>
              </form>
            </div>
            <!-- /.card -->        
          </div>
          <div class="col-md-12">
            <!-- general form elements -->
            <div class="card card-primary">
              <div class="card-header">
                <h3 class="card-title">Booking Log</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    
                    <th>#</th>
                    <th>Location</th>
                    <th>Remark</th>
                    <th>Status</th>
                    <th>Date</th>
                  </tr>
                  </thead>
                  <tbody>
                    @if (count($datalogs) > 0)
            @php ($i = 1)
            @foreach ($datalogs as $datalog)
                  <tr>
                    <td>{{ $i }}</td>
                    <td>{{ $datalog->currentstatus }}</td>
                    <td>{{ $datalog->remark }}</td>
                    <td>{{ $datalog->status }}</td>
                    <td>{{ $datalog->created_at }}</td>
                  </tr>
            @php ($i++)   
            @endforeach
            @endif
                  </tbody>
                </table>
              </div>
            </div>
            <!-- /.card -->        
          </div>
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
@endsection