 @extends('admin.layouts.app', ['activePage' => 'dashboard', 'titlePage' => __('Dashboard')])

@section('content')
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1> Booking</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item ">Booking</li>
          
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">

          
          <div class="col-md-12">
            <!-- general form elements -->
            <div class="card card-primary">
              <div class="card-header">
                <h3 class="card-title">Booking Log</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    
                    <th>#</th>
                    <th>Location</th>
                    <th>Remark</th>
                    <th>Status</th>
                    <th>Date</th>
                  </tr>
                  </thead>
                  <tbody>
                    @if (count($datalogs) > 0)
            @php ($i = 1)
            @foreach ($datalogs as $datalog)
                  <tr>
                    <td>{{ $i }}</td>
                    <td>{{ $datalog->currentstatus }}</td>
                    <td>{{ $datalog->remark }}</td>
                    <td>{{ $datalog->status }}</td>
                    <td>{{ $datalog->created_at }}</td>
                  </tr>
            @php ($i++)   
            @endforeach
            @endif
                  </tbody>
                </table>
              </div>
            </div>
            <!-- /.card -->        
          </div>
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
@endsection